//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.2 Page 48
//Title: Temperature and Heat Flow at midway of cylinder
//======================================================

model Ex3_2
extends Modelica.Math;
//=============
// Parameter Section

parameter Real ri(unit = "m") = 0.025 " Inner radius of the cylinder";
parameter Real ro(unit = "m") = 0.05 " Outer radius of the cylilnder";
parameter Real Ti(unit = "C") = 200 " Temperature of Inner surface";
parameter Real To(unit = "C") = 100 " Temperature of Outer surface";
parameter Real k(unit = "W/m C") = 70 " Thermal Conductivity of the cylinder";
parameter Real r(unit = "m") = 0.0375 "Midpoint of the surface";
parameter Real l(unit = "m") = 1 "Length of the cylinder";

//=============
// Variable Section

Real Tx(unit = "C")  " Temperature of midway point";
Real Q(unit= "kW/m") " Heat Transfer Rate";

//=============
// Equation Section

equation

Q= ((2*3.14*k*l)*(Ti-To))/(log(ro/ri))/1000;

Tx= Ti-((Ti-To)*log(r/ri)/log(ro/ri));


end Ex3_2;
//======================================================
