//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.24 Page 93
//Title: Heat Transfer in Nuclear rod
//======================================================

model Ex3_24
extends Modelica.Math;
//=============
// Parameter Section

parameter Real r0 (unit = " m ") = 0.0125 " Outer radius of rod ";
parameter Real k (unit = " W/ m K ") = 20 " Thermal Conductivity of the rod ";
parameter Real Q (unit = "MW/m^2 ") = 2.5 " Rate of heat removal ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//=============
// Variable Section

Real q0(unit= "W/m^3") " Heat Transfer Rate ";
Real T (unit= "C") " Temperature Drop ";
//=============
// Equation Section

equation
q0=4*Q*(10^6)/r0;
T=-3*(q0*r0*r0)/(16*k);

end Ex3_24;
//======================================================
