//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.34 Page 117
//Title: Insulation of fin
//======================================================

model Ex3_34
extends Modelica.Math;
//=============
// Parameter Section

parameter Real L (unit = "m") = 0.1  " Length of the fin ";
parameter Real d (unit = "m") = 0.01  " Diameter of the fin ";
parameter Real h(unit = "W/m^2 K ")= 5000 "Heat transfer coefficient ";
parameter Real k(unit = "W/m K ") = 16 "Thermal Conductivity  ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//=============
// Variable Section


Real a (unit= "m^2") " Area of the cylinder ";
Real p (unit= "m") " Perimeter of the cylinder ";
Real m(unit = "") "Value of m";
Real eta(unit= "") " Efficiency ";
Real pinc(unit= "") " Percentage increase with fin ";

     
//=============
// Equation Section

equation

a=pi*d*d/4;
p=pi*d;
m=((h*p)/(k*a))^0.5;
eta=tanh(m*L)/((h*a)/(k*p))^0.5;
pinc=(eta-1)*100;

end Ex3_34;
//======================================================
//Thus this configuration produces only an increase of 13% in heat dissipation so this is undesirable.
