//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.35 Page 119
//Title: Measurement error in temperature
//======================================================

model Ex3_35
extends Modelica.Math;
//=============
// Parameter Section

parameter Real T[2] (unit = "C") = {84,40}  " Temperature at base and recorded temperature ";
parameter Real L (unit = "m") = 0.12  " Length of the fin ";
parameter Real t (unit = "m") = 0.0015  " Thickness of the fin ";
parameter Real h(unit = "W/m^2 K ")= 23.3 "Heat transfer coefficient ";
parameter Real k(unit = "W/m K ") = 55.8 "Thermal Conductivity of Steel  ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//=============
// Variable Section

Real m(unit = "") "Value of m";
Real Tact (unit = "C") " Temperature actual";
Real Terr (unit = "C") " Error in temperature measurement ";

//=============
// Equation Section

equation

m=(h/(k*t))^0.5;
Tact=(T[1]-((cosh(m*L))^(-1)*T[2]))/(1-(cosh(m*L))^(-1));
Terr=Tact-T[1];

end Ex3_35;
//======================================================
