//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.4 Page 55
//Title: Heat Flow through variable thermal conductivity
//======================================================

model Ex3_4

//=============
// Parameter Section

parameter Real x(unit = "m") = 0.4 " Thickness of furnace wall";
parameter Real T[2] (unit = "C") = {300,50} " Temperatures at the extremes";

//=============
// Variable Section

Real Q(unit= "W/m^2") " Heat Transfer Rate per unit area";

//=============
// Equation Section

equation

Q= (((0.005/2)*((T[1]^2)-(T[2]^2)))-((5E-6/3)*((T[1]^3)-(T[2]^3))))/(x);


end Ex3_4;
//======================================================
