//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-3: One Dimensional Steady State Heat Conduction
//Example: 3.6 Page 58
//Title: Heat Flow through variable thermal conductivity in a cylinder
//======================================================

model Ex3_6
extends Modelica.Math;
//=============
// Parameter Section

parameter Real ri(unit = "m") = 0.01 " Inner radius";
parameter Real ro(unit = "m") = 0.02 " Outer radius";
parameter Real T[2] (unit = "C") = {310,290} " Respective temperatures";
parameter Real ko (unit = "W/m C") = 371.9 " Thermal Conductivity at T=0";
parameter Real B (unit = "1/C") = 9.25E-5 " Temperature coefficient of thermal conductivity";


//=============
// Variable Section
Real Q(unit= "kW/m") " Heat Transfer Rate per unit area";
Real km(unit= "W/m C") " Thermal Conductivty at a mean temperature";
Real Tm(unit = "C")  " Mean temperature";

//=============
// Equation Section

equation

Tm=((T[1]-150)+(T[2]-150))/2;

km=(ko)*(1- (B*Tm));

Q= ((2*3.14)*km*(T[1]-T[2]))/(1000*log(ro/ri));

end Ex3_6;
//======================================================
