//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-5: Transient Heat Conduction 
//Example: 5.1 Page 159
//Title: Heat transfer and temperature
//======================================================

model Ex5_1
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real x[2](unit="m")={0,0.5} " Thickness of concrete slab";
parameter Real A(unit="m^2")=5 " Area";
parameter Real k(unit="W/mK")=1.2 " Thermal Conductivity";
parameter Real a1(unit="m^2/hour")=1.77e-3 " Thermal Diffusivity";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Qo(unit="W") " Heat transfer rate entering slab";
Real Ql(unit="W") " Heat transfer rate leaving slab";
Real Q(unit="W") " Rate of heat storage";
Real Tr[2](unit="K/hour") " Rate of temperature change ";
Real xmax(unit="m") " Point of maximum heating or cooling";

//=============
// Equation Section

equation

//T=60- 50*x + 12*(x^2) +20*(x^3) -15*(x^4)
//Partial derivative of T wrt x T'= -50+24*(x)+60*(x^2)-60*(x^3)
//Partial derivative of T' wrt x T''= 24+120*(x)-180*(x^2)
//Partial derivative of T'' wrt x T'''= 120-360*(x)

Qo=(-k*A)*(-50+24*(x[1])+60*(x[1]^2)-60*(x[1]^3));
Ql=(-k*A)*(-50+24*(x[2])+60*(x[2]^2)-60*(x[2]^3));
Q=Qo-Ql;
Tr[1]=a1*(24+120*(x[1])-180*(x[1]^2));
Tr[2]=a1*(24+120*(x[2])-180*(x[2]^2));
120-360*xmax=0;


end Ex5_1;
//======================================================
