//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-5: Transient Heat Conduction 
//Example: 5.13 Page 186
//Title: Time and temperature
//======================================================

model Ex5_13
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real ro(unit="m")=6e-2 " Radius";
parameter Real r1(unit="m")=5.4e-2 " Radius";
parameter Real a1(unit="m^2/s")=6.11e-6 " Thermal Diffusivity";
parameter Real k(unit="W/mK")=21 " Thermal Conductivity";
parameter Real Ti(unit="C")=20 " Initial temperature";
parameter Real Tf(unit="C")=820 " Final temperature";
parameter Real Ta(unit="C")=800 " Axis temperature";
parameter Real h(unit="W/m^2 K")=140 " Heat transfer coefficient";
parameter Real Fo(unit="")=5.2 " Fourier No obtained from Fig5.10 on pg 187";
parameter Real T1s(unit="")=0.85 " Value obtained from Fig5.11 on pg 188";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Ts(unit="C")" Temperature of surface";
Real t(unit="s")" Time";

//=============
// Equation Section

equation

Fo=a1*t/(ro*ro);
(Ts-Tf)/(Ta-Tf)=T1s;

end Ex5_13;
//======================================================
