//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-5: Transient Heat Conduction 
//Example: 5.15 Page 192
//Title: Temperature
//======================================================

model Ex5_15
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real x(unit="m")=0.05 " Thickness";
parameter Real a1(unit="m^2/s")=8.4e-5 " Thermal Diffusivity";
parameter Real k(unit="W/mK")=215 " Thermal Conductivity";
parameter Real Ti(unit="C")=250 " Initial temperature";
parameter Real Tf(unit="C")=50 " Final temperature";
parameter Real h(unit="W/m^2 K")=500 " Heat transfer coefficient";
parameter Real t(unit="s")=3600 " Time";
parameter Real T1s(unit="")=0.62 " Value from Fig 5.16 on pg 193";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real T(unit="C")" Temperature ";
Real y1(unit="")" Input to find T";
Real y2(unit="")" Input to find T";

//=============
// Equation Section

equation

y1=(h/k)*(a1*t)^0.5;
y2=(x/2)/(a1*t)^0.5;
(T-Ti)/(Tf-Ti)=T1s;

end Ex5_15;
//======================================================
