//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-5: Transient Heat Conduction 
//Example: 5.17 Page 197
//Title: Centreline temperature of Billet 
//======================================================

model Ex5_17
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real L1(unit="m")=0.25 " Length";
parameter Real L2(unit="m")=0.2 " Length";
parameter Real L3(unit="m")=0.1 " Length";
parameter Real k(unit="W/mK")=37 " Thermal Conductivity";
parameter Real h(unit="W/m^2 K")=185 " Convective Heat transfer coefficient";
parameter Real a1(unit="m^2/hour")=0.025 " Thermal diffusivity";
parameter Real Tf(unit="C")=1000 " Medium temperature";
parameter Real Ti(unit="C")=30 " Initial temperature";
parameter Real t(unit="hour")=1.5 " Time";

//From Fig5.7 on pg 183
parameter Real Px1(unit="")=0.68 " Solution of infinite plate";
parameter Real Px2(unit="")=0.57 " Solution of infinite plate";
parameter Real Px3(unit="")=0.22 " Solution of infinite plate";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Fop1(unit="") " Fourier no of plate1";
Real Fop2(unit="") " Fourier no of plate2";
Real Fop3(unit="") " Fourier no of plate3";
Real B1(unit="") " h/kl for plate1";
Real B2(unit="") " h/kl for plate2";
Real B3(unit="") " h/kl for plate3";
Real T(unit="C")" Centreline temperature";

//=============
// Equation Section

equation

Fop1=a1*t/L1^2;
Fop2=a1*t/L2^2;
Fop3=a1*t/L3^2;
B1=k/(h*L1);
B2=k/(h*L2);
B3=k/(h*L3);
(T-Tf)/(Ti-Tf)=Px1*Px2*Px3;

end Ex5_17;
//======================================================
