//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-5: Transient Heat Conduction 
//Example: 5.2 Page 164
//Title: Time taken
//======================================================

model Ex5_2
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real d[3](unit="m")={0.4,0.4,5e-3} " Dimensions of copper slab";
parameter Real k(unit="W/mK")=370 " Thermal Conductivity";
parameter Real h(unit="W/m^2 K")=90 " Heat transfer coefficient";
parameter Real c(unit="J/kg K")=380 " Specific heat";
parameter Real p1(unit="kg/m^3")=9000 " Density";
parameter Real To(unit="C")=250 " Uniform temperature";
parameter Real Ti(unit="C")=30 " Surface temperature";
parameter Real T(unit="C")=90 " Slab temperature";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real A(unit="m^2") " Area";
Real V(unit="m^3") " Volume";
Real Lc(unit="m") " Corrected length";
Real Bi(unit="") " Biot No";
Real t(unit="s") " Time";

//=============
// Equation Section

equation

A=2*d[1]*d[2];
V=d[1]*d[2]*d[3];
Lc=V/A;
Bi=h*Lc/k;
((T-Ti)/(To-Ti))=e^(-(h*A*t)/(p1*c*V));

end Ex5_2;
//======================================================
