//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-5: Transient Heat Conduction 
//Example: 5.22 Page 214
//Title: Time lag and heat flow
//======================================================

model Ex5_22
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real x(unit="m")=0.1 " Depth";
parameter Real t(unit="hour")=12 " Time period";
parameter Real a1(unit="m^2/hour")=0.02 " Thermal Diffusivity";
parameter Real k(unit="W/mK")=1.8 " Thermal Conductivity";
parameter Real T[2](unit="C")={800,200} " Maximum and minimum temperatures";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real tl(unit="hour") " Time lag";
Real w(unit="rad/hour") " Angular frequency";
Real Q(unit="kJ/m^2") " Heat flow";

//=============
// Equation Section

equation

w=(2/t);
tl=(1/(2*a1*w*pi))^0.5*x;
Q=(2/(pi*w*a1)^0.5)*k*(3600/1000)*((T[1]-T[2])/2);

end Ex5_22;
//======================================================
