//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-5: Transient Heat Conduction 
//Example: 5.23 Page 215
//Title: Depth of penetration
//======================================================

model Ex5_23
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real N(unit="rpm")=2000 " Speed of engine";
parameter Real a1(unit="m^2/hour")=0.06 " Thermal Diffusivity";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real To(unit="hour") " Period of oscillation";
Real x(unit="m") "Depth till which temperature fluctuations occur";

//=============
// Equation Section

equation

To=1/(N*60);
x=1.6*(pi*a1*To)^0.5;

end Ex5_23;
//======================================================
