//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-5: Transient Heat Conduction 
//Example: 5.9 Page 177
//Title: Time to cool concrete 
//======================================================

model Ex5_9
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real x(unit="m")=5e-2 " Thickness";
parameter Real k(unit="W/mK")=1.279 " Thermal Conductivity";
parameter Real a1(unit="m^2/hour")=1.77e-3 " Thermal Diffusivity";
parameter Real To(unit="C")=55 " Initial temperature";
parameter Real T(unit="C")=45 " Final temperature";
parameter Real Ts(unit="C")=35 " Surface temperature";
parameter Real erf(unit="")=0.482 " Error function"; //Taking 0.5=erf(0.482) from table 5.1 on pg175

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real t(unit="hour")" Time to cool";

//=============
// Equation Section

equation

x/(2*((a1*t)^0.5))=erf;

end Ex5_9;
//======================================================
