//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-6: Fundamentals of Convective Heat Transfer
//Example: 6.6 Page 247
//Title: Maximum Temperature Rise and Heat Flux
//======================================================

model Ex6_6
extends Modelica.Math;
//=============
// Parameter Section

parameter Real l (unit = " m ") = 2e-3 " Distance between clearance and bearing ";
parameter Real T[2](unit = " C ") ={30,10} "Temperature of shaft and bearing respectively ";
parameter Real myu( unit = "kg/m s ")= 0.8 " Viscosity of oil ";
parameter Real k( unit = "W/m C ")= 0.15 " Thermal Conductivity of oil ";
parameter Real u ( unit = "m/s") = 6 " Velocity of oil ";

//=============
// Variable Section

Real qo (unit = " kW/m^2 ")  " Heat Transfer at bearing ";
Real ql (unit = " kW/m^2 ")  " Heat Transfer at shaft ";
Real Tmax(unit = " C ") "Maximum Temperature rise ";

//=============
// Equation Section

equation

qo=(-((myu*u*u)/(2*l))-(k*(T[1]-T[2])/l))/1000;
ql=(((myu*u*u)/(2*l))-(k*(T[1]-T[2])/l))/1000;
Tmax=T[2] + (myu*u*u*(0.604-(0.604*0.604))/(2*k)) + (0.604*(T[1]-T[2]));

end Ex6_6;
//======================================================
