//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-7: Forced Convection Systems
//Example: 7.17 Page 312
//Title: Heat transfer coefficient and heat transfer rate
//======================================================

model Ex7_17
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real k(unit="W/m K")=0.175 " Thermal conductivity";
parameter Real dT(unit="C")=50 " Water inlet and outer temperatures";
parameter Real D(unit="m")=6e-3 " Inner Diameter";
parameter Real L(unit="m")=8 " Length";
parameter Real Nu(unit="")=3.66 " Nusselt no";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real h(unit= "W/m^2 K")" Heat transfer coefficient ";
Real Q(unit="W") " Heat transfer rate";

//=============
// Equation Section

equation

Nu=h*D/k;
Q=h*(pi*D*L)*dT;

end Ex7_17;
//======================================================
