//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-7: Forced Convection Systems
//Example: 7.2 Page 275
//Title: Local heat transfer coefficient
//======================================================

model Ex7_2
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real x(unit = "m") = 0.4 " Distance of plane from the plate  ";
parameter Real u(unit="m/s")=3 " Velocity";
parameter Real T[2](unit="C")={134,20} " Temperatures";
parameter Real d[2](unit="m")={2,1.5} " Dimensions";

//Properties of air at film temperature of 77C
parameter Real v1(unit = "m^2/s") = 20.76e-6 " Kinematic viscosity";
parameter Real p1(unit = "kg/m^3") = 0.998 " Density";
parameter Real Cp(unit = "kJ/kgK") = 1.009 " Specific heat";
parameter Real k(unit = "W/m K") = 0.03 " Thermal Conductivity";
parameter Real Pr(unit = "") = 0.697 " Prandtl Number";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Re(unit= "")" Reynolds no";
Real Nu(unit= "")" Nusselt no";
Real h(unit= "W/m^2 K")" Heat transfer coefficient ";
Real havg(unit= "W/m^2 K")" Average heat transfer coefficient ";
Real Q(unit= "W")" Heat transfer ";
Real Qavg(unit= "W")" Average heat transfer";

//=============
// Equation Section

equation

Re=x*u/v1;
Nu=0.332*(Re^0.5)*(Pr^(1/3));
Nu=h*x/k;
havg=2*h;
Q=havg*x*d[2]*(T[1]-T[2]);
Qavg=2*Q;

end Ex7_2;
//======================================================
