//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-7: Forced Convection Systems
//Example: 7.21 Page 319
//Title: Heat transfer coefficient and heat transferred
//======================================================

model Ex7_21
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real u(unit="m/s")=1 " Velocity";
parameter Real Ts(unit="C")=90 " Temperature of surface";
parameter Real Tw[2](unit="C")={50,64} " Water temperatures at inlet and exit";
parameter Real D(unit="m")=1.5e-2 " Diameter";
parameter Real L(unit="m")=3 " Length";

//Property values of water at 57C
parameter Real v1(unit="m^2/s")=0.517e-6 " Kinematic Viscosity";
parameter Real k(unit="W/mK")=0.65 " Thermal conductivity";
parameter Real Pr(unit="")=3.15 " Prandtl No";
parameter Real p1(unit="kg/m^3")=990 " Density";
parameter Real Cp(unit="J/kgK")=4184 " Specific heat";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Nu(unit="")"Nusselt no";
Real h(unit="W/m^2 K")" Heat transfer coefficient";
Real Re(unit="")"Reynolds No";
Real Q(unit="kW")" Total heat transferred";

//=============
// Equation Section

equation

Re=u*D/v1;
Nu=0.023*(Re^0.8)*(Pr^0.4);
Nu=h*D/k;
Q=h*(pi*D*L)*(Ts -((Tw[1]+Tw[2])/2))/1000;

end Ex7_21;
//======================================================
