//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-7: Forced Convection Systems
//Example: 7.25 Page 322
//Title: Heat transfer coefficient
//======================================================

model Ex7_25
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real u(unit="m/s")=30 " Velocity";
parameter Real Ts(unit="C")=50 " Temperature of surface";
parameter Real T[2](unit="C")={16,32} " Temperature of surface";
parameter Real D[2](unit="m")={3.125e-2,5e-2} " Respective diameters ";

//Properies of air at 24C
parameter Real v1(unit="m^2/s")=15.9e-6 " Kinematic Viscosity";
parameter Real k(unit="W/mK")=0.0263 " Thermal conductivity";
parameter Real p1(unit="kg/m^3")=1.614 " Density";
parameter Real Cp(unit="J/kg K")=1007 " Thermal diffusivity";
parameter Real Pr(unit="")=0.707 " Prandtl No";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Dh(unit="m")" Hydraulic diameter";
Real h(unit="W/m^2 K")" Heat transfer coefficient";
Real Re(unit="")" Reynolds No";
Real Nu(unit="")" Nusselt No";

//=============
// Equation Section

equation

Dh=D[2]-D[1];
Re=u*Dh/v1;
Nu=h*Dh/k;
Nu=0.023*(Re^0.8)*(Pr^0.4);

end Ex7_25;
//======================================================
