//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-7: Forced Convection Systems
//Example: 7.26 Page 324
//Title: Minimum length
//======================================================

model Ex7_26
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real m(unit="kg/s")=2.3 " Mass flow rate";
parameter Real Ts(unit="C")=200 " Temperature of surface";
parameter Real Tw[2](unit="C")={120,149} " Water inlet and outlet temperatures";
parameter Real D(unit="m")=2.5e-2 " Diameter";

//Property values of water at 134.5C
parameter Real v1(unit="m^2/s")=0.594e-6 " Kinematic Viscosity";
parameter Real k(unit="W/mK")=84.9 " Thermal conductivity";
parameter Real Pr(unit="W/mK")=0.0087 " Prandtl No";
parameter Real p1(unit="kg/m^3")=916 " Density";
parameter Real Cp(unit="J/kg")=1356.5 " Specific heat";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Q(unit="kW") " Heat transferred";
Real Nu(unit="")" Nusselt no";
Real h(unit="W/m^2 K")" Heat transfer coefficient";
Real Re(unit="")" Reynolds No";
Real Pe(unit="")" Peclet No";
Real L(unit="m") " Length";
Real u(unit="m/s") " Velocity";

//=============
// Equation Section

equation

Q=m*Cp*(Tw[2]-Tw[1])/1000;
u=4*m/(p1*pi*D*D);
Re=u*D/v1;
Pe=Re*Pr;
Nu=4.82+0.0185*(Pe^0.827);
Nu=h*D/k;
Q*1000=(h*pi*D*L)*(Ts-((Tw[2]+Tw[1])/2));

end Ex7_26;
//======================================================
