//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-7: Forced Convection Systems
//Example: 7.8 Page 296
//Title: Heat loss
//======================================================

model Ex7_8
extends Modelica.Math;
import SI = Modelica.SIunits;
//=============
// Parameter Section

parameter Real u(unit="km/hour")=36 " Velocity";
parameter Real T1(unit="C")=30 " Temperature of surface";
parameter Real T2(unit="C")=10 " Air Temperature";
parameter Real l[2](unit="m")={0.3,1.7} " Dimensions";

//Properties of air at film temperature 20C
parameter Real v1(unit = "m^2/s") = 15e-6 " Kinematic viscosity";
parameter Real Pr(unit="")=0.707 " Prandtl number";
parameter Real k(unit="W/m K")=2.59e-2 " Thermal conductivity";

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Re(unit= "")" Reynolds no";
Real h(unit= "W/m^2 K")" Heat transfer coefficient";
Real Nu(unit= "")" Nusselt no";
Real Q(unit= "W")" Heat lost";

//=============
// Equation Section

equation

Re=u*(l[1]/v1)*(5/18);
Nu=h*l[1]/k;
Nu=0.027*(Re^0.805)*(Pr^(1/3));
Q=h*l[1]*l[2]*pi*(T1-T2);

end Ex7_8;
//======================================================
