//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-8: Natural Convection
//Example: 8.11 Page 352
//Title: Heat loss in a sphere
//======================================================

model Ex8_11
extends Modelica.Math;
import SI = Modelica.SIunits;

//=============
// Parameter Section

parameter Real D (unit = " m ") = 10e-3 " Diameter of sphere ";
parameter Real T[2]( unit = " C ")= {20,260} " Temperatures of air and sphere respectively";

//Surface properties at 140 degree celsius

parameter Real k (unit = " W/m C ") = 0.0349 " Thermal Conductivity of air ";
parameter Real v1 (unit = " m^2/s ") = 27.8e-6 " Kinematic Viscosity of air ";
parameter Real Pr( unit = "") =0.684 " Prandtl Number ";

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real B (unit = " K^-1 ") " Volumetric Coefficient of air ";
Real Tf(unit = "C") " Film Temperature ";
Real Ra( unit = "") " Rayleigh Number ";
Real Nu( unit = "") " Nusselt Number ";
Real h(unit = "W/m^2 C") " Average heat transfer coefficient";
Real Q(unit = "W") " Heat Loss ";

//=============
// Equation Section

equation

Tf=(T[1]+T[2])/2;
B=1/(Tf+273);
Ra= ((g_n*B*(D^3)*(T[2]-T[1])*Pr))/(v1^2);
Nu=2+0.43*(Ra^0.25);
h=Nu*k/D;
Q=(h*pi*(D*D)*(T[2]-T[1]));

end Ex8_11;
//======================================================
