//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-8: Natural Convection
//Example: 8.13 Page 355
//Title: Effective Thermal Conductivity
//======================================================

model Ex8_13
extends Modelica.Math;
import SI = Modelica.SIunits;

//=============
// Parameter Section

parameter Real t (unit = " m ") = 15e-3 " Thickness of slot ";
parameter Real l(unit = " m ") = 2 " Length of slot ";
parameter Real T[2]( unit = " C ")= {20,120} " Temperatures of air and plate respectively";

//Surface properties at 70 degree celsius

parameter Real k (unit = " W/m C ") = 0.0295 " Thermal Conductivity of air ";
parameter Real v1 (unit = " m^2/s ") = 2e-5 " Kinematic Viscosity of air ";

final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real B (unit = " K^-1 ") " Volumetric Coefficient of air ";
Real Tf(unit = " C") " Film Temperature ";
Real Gr(unit ="") " Grashof Number ";
Real ke(unit = " W/m C") " Effective thermal conductivity";
Real Q(unit = " W") " Heat Loss ";

//=============
// Equation Section

equation

Tf=(T[1]+T[2])/2;
B=1/(Tf+273);
Gr= (g_n*B*(t^3)*(T[2]-T[1]))/(v1^2);
ke=0.064*k*(Gr^(1/3))*((l/t)^(-1/9));
Q=ke*l*l*(T[2]-T[1])/t;

end Ex8_13;
//======================================================
