//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-8: Natural Convection
//Example: 8.2 Page 341
//Title: Average heat Transfer Coefficient
//======================================================

model Ex8_2
extends Modelica.Math;
import SI = Modelica.SIunits;

//=============
// Parameter Section

parameter Real L (unit = " m ") = 0.3 " Length of the glass plate ";
//Surface properties at 52 degree celsius
parameter Real k (unit = " W/m C ") = 28.15e-3 " Thermal Conductivity of air ";
parameter Real v1 (unit = " m^2/s ") = 18.41e-6 " Kinematic Viscosity of air ";
parameter Real Pr (unit = "") = 0.7 " Prandtl Number ";
parameter Real B (unit = " K^-1 ") = 3.07e-3 " Volumetric Coefficient of air ";
parameter Real T[2]( unit = " C ")= {27,77} " Temperatures of air and plate ";
parameter Real u( unit = " m/s ")= 4 " Velocity of blowing air ";
final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real Tf( unit = "C") " Film Temperature ";
Real Gr( unit = "") " Grashoff Number ";
Real Ra( unit = "") " Rayleigh Number ";
Real Re( unit = "") " Reynolds Number ";
Real Nu[2]( unit = "") " Nusselt Number ";
Real h[2](unit = "W/m^2 C") " Average heat transfer coefficient ";

//=============
// Equation Section

equation

Tf=(T[1]+T[2])/2;
Gr= (g_n*B*(L^3))*(T[2]-T[1])/(v1^2);
Ra=Gr*Pr;
Nu[1]=0.677*(Pr^(0.5))*(Gr^0.25)*((0.952+Pr)^(-0.25));
h[1]=Nu[1]*k/L;
Re=u*L/v1;
Nu[2]=0.664*(Re^0.5)*(Pr^(1/3));
h[2]=Nu[2]*k/L;

end Ex8_2;
//======================================================
