//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-8: Natural Convection
//Example: 8.8 Page 349
//Title: Heat loss in pipe
//======================================================

model Ex8_8
extends Modelica.Math;
import SI = Modelica.SIunits;

//=============
// Parameter Section

parameter Real L (unit = " m ") = 3 " Length of the pipe";
parameter Real D (unit = " m ") = 0.2 " Diameter of the pipe";
parameter Real T[2]( unit = " C ")= {20,100} " Temperatures of air and surface respectively";

//Surface properties at 60 degree celsius

parameter Real k (unit = " W/m C ") = 28.96e-3 " Thermal Conductivity of air ";
parameter Real v1 (unit = " m^2/s ") = 18.97e-6 " Kinematic Viscosity of air ";
parameter Real Pr( unit = "") =0.696 " Prandtl Number ";

final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real B (unit = " K^-1 ") " Volumetric Coefficient of air ";
Real Tf(unit = "C") " Film Temperature ";
Real Ra( unit = "") " Rayleigh Number ";
Real Nu( unit = "") " Nusselt Number ";
Real h(unit = "W/m^2 C") " Average heat transfer coefficient";
Real Q(unit = "W/m") " Heat Loss per metre length ";

//=============
// Equation Section

equation

Tf=(T[1]+T[2])/2;
B=1/(Tf+273);
Ra= ((g_n*B*(L^3)*(T[2]-T[1])*Pr))/(v1^2);
Nu=0.1*(Ra^(1/3));
h=Nu*k/L;
Q=h*pi*D*(T[2]-T[1]);

end Ex8_8;
//======================================================
