//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-8: Natural Convection
//Example: 8.9 Page 350
//Title: Heat loss in pipe 2
//======================================================

model Ex8_9
extends Modelica.Math;
import SI = Modelica.SIunits;

//=============
// Parameter Section

parameter Real L (unit = " m ") = 0.1 " Outside diameter of steam pipe ";
parameter Real T[2]( unit = " C ")= {30,170} " Temperatures of air and surface respectively";

//Surface properties at 100 degree celsius

parameter Real k (unit = " W/m C ") = 32.1e-3 " Thermal Conductivity of air ";
parameter Real v1 (unit = " m^2/s ") = 23.13e-6 " Kinematic Viscosity of air ";
parameter Real Pr( unit = "") =0.688 " Prandtl Number ";
parameter Real e( unit = "") =0.9 " Emissivity of wall ";
final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

//=============
// Variable Section

Real B (unit = " K^-1 ") " Volumetric Coefficient of air ";
Real Tf(unit = " C") " Film Temperature ";
Real Ra( unit = "") " Rayleigh Number ";
Real Nu( unit = "") " Nusselt Number ";
Real h(unit = " W/m^2 C") " Average heat transfer coefficient";
Real Q(unit = " W/m") " Heat Loss per metre length ";

//=============
// Equation Section

equation

Tf=(T[1]+T[2])/2;
B=1/(Tf+273);
Ra= ((g_n*B*(L^3)*(T[2]-T[1])*Pr))/(v1^2);
Nu=(0.6+ ( (0.387*Ra^(1/6)) /( 1+ (0.559/Pr)^(9/16))^(8/27)))^2 ;
h=Nu*k/L;
Q=(h*pi*L*(T[2]-T[1]))+(e*pi*L*sigma*((T[2]+273)^4-(T[1]+273)^4));

end Ex8_9;
//======================================================
