//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-9: Thermal Radiation-Basic Relations
//Example: 9.5 Page 389
//Title: Wavelength and Emissivity
//======================================================

model Ex9_5
extends Modelica.Math;
//=============
// Parameter Section

parameter Real E(unit = " W/m^3") = 1.37e10 "Emissive Power ";
parameter Real T (unit = " C") = 827 " Temperature  ";
parameter Real C3 (unit = " mK") = 0.289e-2 " Wien's Displacement Law ";
final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";

//=============
// Variable Section

Real L (unit = " micro m ") " Wavelength of radiation ";
Real Ebmax( unit = "W/m^3 ")" Maximum Emissive power";
Real e(unit ="")" Emissivity of the body ";

//=============
// Equation Section

equation

Ebmax=((T+273)^5)*(1.307e-5);
e=E/Ebmax;
L=C3*(1e6)/(T+273);

end Ex9_5;
//======================================================
