//R.C. Sachdeva, Fundamentals of Engineering Heat and Mass Transfer (SI Units),Fourth Edition, New Age International Publishers, 2010

//Chapter-9: Thermal Radiation-Basic Relations
//Example: 9.6 Page 389
//Title: True Temperature of the body
//======================================================

model Ex9_6
extends Modelica.Math;
//=============
// Parameter Section

parameter Real E(unit = "") = 0.6 "Emissivity ";
parameter Real T (unit = " C") = 1400 " Pyrometer Temperature of the body ";
parameter Real C2 (unit = " mK") = 1.4387e-2 " Constant ";
parameter Real L (unit = "m") = 0.65e-6 "Wavelength ";
final constant Real sigma(final unit="W/(m2.K4)") = 5.670367e-8 "Stefan-Boltzmann constant ";

//=============
// Variable Section

Real Tb (unit = " K ") " Temperature of the body ";
Real Tbc (unit = " C ") " Temperature of the body in celsius ";

//=============
// Equation Section

equation

Tb=1/(1/(T+273)- ((L*log(1/E))/C2));
Tbc=Tb-273;

end Ex9_6;
//======================================================
