//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 1: Introduction
//Example: 1.1 Page 13
//Title: Heat Conduction
//======================================================
model Ex1_1

//==========
//Parameter Section

parameter Real K(unit = "W/(m K)") = 35 "Thermal Conductivity of the Material of the Slab";

//==========
//Variable Section

input Real Tf(unit = "deg C",start = 110) "Temperature of the Front Face of the slab";
input Real Tb(unit = "deg C",start = 50) "Temperature of the Back Face of the Slab";
input Real x(unit = "m",start = 0.03) "Thickness of the Slab";
input Real A(unit = "m^2",start = 0.4) "Cross Sectional Area of the Slab";
output Real q(unit = "kW/m^2") "Heat Flux through the Slab";
output Real Q(unit = "kW") "Heat Transfer Rate through the Slab";

//==========
//Equation Section

equation
q*1000 = -K*((Tb-Tf)/x);      //1 kW = 1000 W //Refer Page 13
Q=q*A;                        //Refer Page 13
end Ex1_1;
//======================================================
