//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 1: Introduction
//Example: 1.3 Page 20
//Title: Heat Convection
//======================================================
model Ex1_3

//==========
//Variable Section

input Real q(unit = "W/m^2",start = 6000) "Heat Flux at the Surface of the Electrical Heater";
input Real Th(unit = "deg C",start = 120) "Temperature of the Electrical Heater";
input Real Tair(unit = "deg C",start = 70) "Temperature of Air";
input Real qn(unit = "W/m^2",start = 2000) "New or Reduced Heat Flux at the Surface of the Electrical Heater";
output Real havg(unit = "W/(m^2 K)") "Average Convective Heat Transfer Co-efficient of the Electrical Heater";
output Real Thn(unit = "deg C") "New or Reduced Temperature of the Electrical Heater";

//==========
//Equation Section

equation
havg = q/(Th-Tair);    //Refer Page 19
Thn = (qn/havg)+Tair;  //Refer Page 21
end Ex1_3;
//======================================================
