//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 11: An Introduction to Mass Transfer
//Example: 11.1 Page 607
//Title: Air Parameters
//======================================================
model Ex11_1

//==========
//Parameter Section

parameter Real P(unit = "Pa") = 101325 "Atmospheric Pressure";
parameter Real R(unit = "J/(kmol K)") = 8.314e3 "Universal Gas Constant";
parameter Real T(unit = "K") = 300 "Temperature";
parameter Real Mn2(unit = "kg/kmol") = 28.02 "Molecular Weight of Nitrogen";
parameter Real Mo2(unit = "kg/kmol") = 32.00 "Molecular Weight of Oxygen";
parameter Real Mar(unit = "kg/kmol") = 39.95 "Molecular Weight of Argon";

//==========
//Variable Section

input Real mn2(start = 0.7556) "Mass Fraction of Nitrogen in Air";
input Real mo2(start = 0.2315) "Mass Fraction of Oxygen in Air";
input Real mar(start = 0.01289) "Mass Fraction of Argon in Air";
output Real Xo2 "Mole Fraction of Oxygen";
output Real po2(unit = "Pa") "Partial Pressure of Oxygen";
output Real Co2(unit = "kmol/m^3") "Concentration of Oxygen";
output Real rhoo2(unit = "kg/m^3") "Partial Density of Oxygen";
Real Mair(unit = "kg/kmol") "Molecular Weight of Air";

//==========
//Equation Section

equation
Mair = (((mn2/Mn2)+(mo2/Mo2)+(mar/Mar))^(-1));
Xo2 = mo2*Mair/Mo2;
po2 = Xo2*P;
Co2 = po2/(R*T);
rhoo2 = Co2*Mo2;
end Ex11_1;
//======================================================
