//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 11: An Introduction to Mass Transfer
//Example: 11.10 Page 647
//Title: Mass Flux of Napthalene
//======================================================
model Ex11_10

//==========
//Parameter Section

parameter Real Mnap(unit = "kg/kgmol") = 128 "Molecular Weight of Napthalene";
parameter Real Mair(unit = "kg/kgmol") = 28.96 "Molecular Weight of Air";
parameter Real nu(unit = "m^2/s") = 1.867e-5 "Kinematic Viscosity of Air";
parameter Real rho(unit = "kg/m^3") = 1.166 "Density of Air";
parameter Real Patm(unit = "mm Hg") = 760 "Atmospheric Pressure";

//==========
//Variable Section

input Real l(unit = "m",start = 5e-2) "Length of the PCB Board";
input Real uair(unit = "m/s",start = 5) "Velocity of Air";
input Real T(unit = "K",start = 303) "Temperature";
output Real mavg(unit = "kg/(m^2 s)") "Average Mass Flux of Napthalene";
Real pv(unit = "mm Hg") "Vapour Pressure of Napthalene";
Real xnap "Mole Fraction of Napthalene";
Real mnap "Mass Fraction of Napthalene";
Real Bnap "Mass Transfer Driving Force Coefficient";
Real Re "Reynolds Number";
Real Nu "Nusselt's Number";
Real Sc "Schmidt Number";
Real D(unit = "m^2/s") "Diffusion Coefficient for Napthalene in Air";
Real gma(unit = "kg/(m^2 s)") "Average Mass Transfer Coefficient for Napthalene";

//==========
//Equation Section

equation
log10(pv) = 11.450-(3729.3/T);
xnap = pv/Patm;
mnap = (xnap*Mnap)/((xnap*Mnap)+((1-xnap)*Mair));
Bnap = (mnap-0)/(1-mnap);
Re = uair*l/nu;
D = 0.86e-5;
Sc = nu/D;
Nu = 0.664*(Re^0.5)*(Sc^(1/3));
Nu = (gma*l)/(rho*D);
mavg = gma*(mnap-0);
end Ex11_10;
//======================================================
