//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 11: An Introduction to Mass Transfer
//Example: 11.16 Page 664
//Title: Rate of Evaporation of Water
//======================================================
model Ex11_16

//==========
//Parameter Section

parameter Real Patm(unit = "kPa") = 101.325 "Atmospheric Pressure";
parameter Real R(unit = "kJ/(kmol K)") = 8.314 "Universal Gas Constant";
parameter Real Mw(unit = "kg/kgmol") = 18 "Molecular Weight of Water";
parameter Real Mair(unit = "kg/kgmol") = 28.96 "Molecular Weight of Air";
parameter Real Mm(unit = "kg/kgmol") = 26.34 "Molecular Weight of the Mixture";
parameter Real mu(unit = "kg/(m s)") = 1.78e-5 "Dynamic Viscosity of Mixture";

//==========
//Variable Section

input Real uair(unit = "m/s",start = 5) "Speed of Air";
input Real lp(unit = "m",start = 0.2) "Length of Pan in the Flow Direction";
input Real Tair(unit = "K",start = 318) "Temperature of Air";
input Real Tw(unit = "K",start = 348) "Temperature of Water";
input Real mw1(start = 0.05) "Mass Fraction of Water in the Stream";
input Real mw2(start = 0.277) "Mass Fraction of Water";
output Real gma(unit = "kg/(m^2 s)") "Average Mass Transfer Coefficient";
Real gm(unit = "kg/(m^2 s)") "Average Mass Transfer Coefficient at a point";
Real D(unit = "m^2/s") "Diffusion Coefficient";
Real rho(unit = "kg/m^3") "Density of Mixture"; 
Real Tf(unit = "K") "Film Temperature";
Real mf "Film Composition";
Real Re "Reynolds Number";
Real Nu "Nusselt's Number";
Real Sc "Schmidt Number";
Real Bm "Mass Transfer Driving Force";

//==========
//Equation section

equation
Tf = (Tw+Tair)/2;
mf = (mw1+mw2)/2;
rho = (Patm*Mm)/(R*Tf);
Re = (lp*uair*rho)/mu;
Sc = mu/D;
Nu = 0.664*(Re^0.5)*(Sc^(1/3));
D = 3.11e-5;
gm = (Nu*rho*D)/lp;
Bm = 0.314;     //From Example 11.15
gma = gm*(log(1+Bm))/Bm;
end Ex11_16;
//======================================================
