//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 11: An Introduction to Mass Transfer
//Example: 11.2 Page 610
//Title: Mass and Mole Fluxes
//======================================================
model Ex11_2

//==========
//Parameter Section

parameter Real Mo2(unit = "kg/kgmol") = 32 "Molecular Weight of Oxygen";
parameter Real Mco2(unit = "kg/kgmol") = 44 "Molecular Weight of Carbon Dioxide";
parameter Real Mc(unit = "kg/kmol") = 12 "Molecular Weight of Carbon";

//==========
//Variable  Section

input Real nCu(unit = "kg/(m^2 s)",start = 0.00241) "Rate of Consumption of Carbon at Steady State";
input Real mO2s(start = 0.20) "Concentration of Oxygen at the s-surface";
input Real mCO2s(start = 0.052) "Concentration of Carbon Dioxide at the s-surface";
input Real rhos(unit = "kg/m^3",start = 0.29) "Density at the s-surface";
output Real JO2(unit = "kmol/(m^2 s)") "Diffusional Mole Flux of Oxygen";
output Real JCO2(unit = "kmol/(m^2 s)") "Diffusional Mole Flux of Carbon Dioxide";
output Real jO2(unit = "kg/(m^2 s)") "Diffusional Mass Flux of Oxygen";
output Real jCO2(unit = "kg/(m^2 s)") "Diffusional Mass Flux of Carbon Dioxide";
Real vO2s(unit = "m/s") "Mass Average Speed of Oxygen through the s-surface";
Real vCO2s(unit = "m/s") "Mass Average Speed of Carbon Dioxide through the s-surface";
Real vs(unit = "m/s") "Overall Mass Average Speed through the s-surface";
Real nO2s(unit = "kg/(m^2 s)") "Mass Flux of Oxygen through the s-surface";
Real nCO2s(unit = "kg/(m^2 s)") "Mass Flux of Carbon Dioxide through the s-surface";

//==========
//Equation Section

equation
nO2s = -Mo2*nCu/12;
nCO2s = Mco2*nCu/12;
vO2s = nO2s/(mO2s*rhos);
vCO2s = nCO2s/(mCO2s*rhos);
vs = (nCO2s+nO2s)/rhos;
jO2 = rhos*mO2s*(vO2s-vs);
jCO2 = rhos*mCO2s*(vCO2s-vs);
JCO2 = nCu/Mc;
JCO2 = -JO2;
end Ex11_2;
//======================================================
