//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 11: An Introduction to Mass Transfer
//Example: 11.4 Page 629
//Title: Transport Properties of Air

//Remarks
//eKi represents e/K of the Species "i".
//phiij represents the constant phi between the Species "i" and "j". Here 1 denotes Nitrogen, 2 Oxygen and 3 Argon.
//======================================================
model Ex11_4

//==========
//Parameter Section

parameter Real MN2(unit = "kg/kgmol") = 28.02 "Molecular Weight of Nitrogen";
parameter Real MO2(unit = "kg/kgmol") = 32 "Molecular Weight of Oxygen";
parameter Real MAr(unit = "kg/kgmol") = 39.95 "Molecular Weight of Argon";
parameter Real sigmaN2(unit = "m") = 3.798e-10 "Atomic Radius of Nitrogen";
parameter Real sigmaO2(unit = "m") = 3.467e-10 "Atomic Radius of Oxygen";
parameter Real sigmaAr(unit = "m") = 3.542e-10 "Atomic Radius of Argon";
parameter Real eKN2(unit = "K") = 71.4 "Reduced Temperature of Nitrogen";
parameter Real eKO2(unit = "K") = 106.7 "Reduced Temperature of Oxygen";
parameter Real eKAr(unit = "K") = 93.3 "Reduced Temperature of Argon";
parameter Real Cpm(unit = "J/(kg K)") = 1006 "Mean Specific Heat Capacity of Air";
parameter Real ohmN2 = 0.9599 "Temperature Dependent Collision Integral of Nitrogen";
parameter Real ohmO2 = 1.057 "Temperature Dependent Collision Integral of Oxygen";
parameter Real ohmAr = 1.021 "Temperature Dependent Collision Integral of Argon";

//==========
//Variable Section

input Real xN2(start = 0.78) "Mole Fraction of Nitrogen in Air";
input Real xO2(start = 0.21) "Mole Fraction of Oxygen in Air";
input Real xAr(start = 0.01) "Mole Fraction of Argon in Air";
input Real muN2d(unit = "kg/(m s)",start = 1.80e-5) "Dynamic Viscosity of Nitrogen Obtained as Data";
input Real muO2d(unit = "kg/(m s)",start = 2.07e-5) "Dynamic Viscosity of Oxygen Obtained as Data";
input Real muArd(unit = "kg/(m s)",start = 2.29e-5) "Dynamic Viscosity of Argon Obtained as Data";
output Real mumd(unit = "kg/(m s)") "Mean Dynamic Viscosity of Air Obtained as Data";
input Real KN2d(unit = "W/(m K)",start = 0.0260) "Thermal Conductivity of Nitrogen Obtained as Data";
input Real KO2d(unit = "W/(m K)",start = 0.02615) "Thermal Conductivity of Oxygen Obtained as Data";
input Real KArd(unit = "W/(m K)",start = 0.01787) "Thermal Conductivity of Argon Obtained as Data";
output Real Kmd(unit = "W/(m K)") "Mean Thermal Conductivity of Air Obtained as Data";
Real muN2(unit = "kg/(m s)") "Dynamic Viscosity of Nitrogen";
Real muO2(unit = "kg/(m s)") "Dynamic Viscosity of Oxygen";
Real muAr(unit = "kg/(m s)") "Dynamic Viscosity of Argon";
Real KN2(unit = "W/(m K)") "Thermal Conductivity of Nitrogen";
Real KO2(unit = "W/(m K)") "Thermal Conductivity of Oxygen";
Real KAr(unit = "W/(m K)") "Thermal Conductivity of Argon";
Real phi12 "Constant";
Real phi21 "Constant";
Real phi13 "Constant";
Real phi31 "Constant";
Real phi23 "Constant";
Real phi32 "Constant";
Real sigmaxjphi1j "Constant";
Real sigmaxjphi2j "Constant";
Real sigmaxjphi3j "Constant";
output Real mum(unit = "kg/(m s)") "Mean Dynamic Viscosity of Air";
output Real Km(unit = "W/(m K)") "Mean Thermal Conductivity of Air";
output Real Pr "Prandtl Number of Air";

//==========
//Equation Section

equation
muN2 = 1.767e-5;
muO2 = 2.059e-5;
muAr = 2.281e-5;
KN2 = 0.02500;
KO2 = 0.02569;
KAr = 0.01782;
phi12 = ((1+(((muN2/muO2)^0.5)*((MO2/MN2)^0.25)))^2)/(((2*(2^0.5)))*((1+(MN2/MO2))^0.5));
phi13 = ((1+(((muN2/muAr)^0.5)*((MAr/MN2)^0.25)))^2)/((2*(2^0.5))*((1+(MN2/MAr))^0.5));
phi23 = ((1+(((muO2/muAr)^0.5)*((MAr/MO2)^0.25)))^2)/((2*(2^0.5))*((1+(MO2/MAr))^0.5));
phi21 = ((1+(((muO2/muN2)^0.5)*((MN2/MO2)^0.25)))^2)/((2*(2^0.5))*((1+(MO2/MN2))^0.5));
phi31 = ((1+(((muAr/muN2)^0.5)*((MN2/MAr)^0.25)))^2)/((2*(2^0.5))*((1+(MAr/MN2))^0.5));
phi32 = ((1+(((muAr/muO2)^0.5)*((MO2/MAr)^0.25)))^2)/((2*(2^0.5))*((1+(MAr/MO2))^0.5));
sigmaxjphi1j = xN2+(xO2*phi12)+(xAr*phi13);
sigmaxjphi2j = (xN2*phi21)+xO2+(xAr*phi23);
sigmaxjphi3j = (xN2*phi31)+(xO2*phi32)+xAr;
mum = ((xN2*muN2)/sigmaxjphi1j)+((xO2*muO2)/sigmaxjphi2j)+((xAr*muAr)/sigmaxjphi3j);
Km =  ((xN2*KN2)/sigmaxjphi1j)+((xO2*KO2)/sigmaxjphi2j)+((xAr*KAr)/sigmaxjphi3j);
mumd = (xN2*muN2d)+(xO2*muO2d)+(xAr*muArd);
Kmd = (xN2*KN2d)+(xO2*KO2d)+(xAr*KArd);
Pr = Cpm*mum/Km;
end Ex11_4;
//======================================================
