//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 2: Heat Conduction Concepts, Thermal Resistance, and the Overall Heat Transfer Coefficient
//Example: 2.12 Page 87
//Title: Design of Siding
//======================================================
model Ex2_12

//==========
//Variable Section

input Real Uold(unit = "W/(m^2 K)",start = 5) "Old Overall Heat Transfer Coefficient of the Aluminum Siding";
input Real Rf(unit = "(m^2 K)/W",start = 0.0005) "Fouling Resistance on the Siding";
output Real Unew(unit = "W/(m^2 K)") "New Overall Heat Transfer Coefficient of the Aluminum Siding";

//==========
//Equation Section

equation
1/Unew = (1/Uold)+Rf;
//The Engineer should redesign the Siding becuase the Fouling Resistance is grater than what it should be for Domestic Applications.
end Ex2_12;
//======================================================
