//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 2: Heat Conduction Concepts, Thermal Resistance, and the Overall Heat Transfer Coefficient
//Example: 2.8 Page 76
//Title: Cooling Time of Resistor
//======================================================
model Ex2_8

//==========
//Parameter Section

parameter Real K(unit = "W/(m K)") = 10 "Thermal Conductivity of the Material of the Resistor";
parameter Real rho(unit = "kg/m^3") = 2000 "Density of the Resistor";
parameter Real Cp(unit = "J/(kg K)") = 700 "Specific Heat Capacity of the Resistor";

//==========
//Variable Section

input Real heff(unit = "W/(m^2 K)",start = 20.17) "Effective Heat Transfer Coefficient of the Resistor";
input Real d(unit = "m",start = 3.6e-3) "Outer Diameter of the Cylindrical Cabinet";
input Real l(unit = "m",start = 10e-3) "Length of the Cylindrical Cabinet";
input Real To(unit = "deg C",start = 78.4228) "Temperature of the Resistor";
input Real Tair(unit = "deg C",start = 35) "Temperature of Air in the Cabinet";
output Real Tc(unit = "s") "Time Constant of the Resistor";
output Real t(unit = "s") "Time Required for Cooling the Resistor";
Real Bi "Biot Number";
Real A(unit = "m^2") "Cross - Sectional Area of the Cylindrical Cabinet";
Real V(unit = "m^3") "Volume of the Cylindrical Cabinet";
Real T(unit = "deg C",start = 41.25166) "Temperature of the Resistor as Function of Time";
Real pi "Constant";

//==========
//Equation Section

equation
pi = 2*Modelica.Math.asin(1.0);     //Constant
A = pi*d*l;
V = pi*(d^2)*l/4;
Bi = heff*(d/2)/K;      //Biot Number Calculation
Tc = (rho*Cp*V)/(heff*A);
T = Tair+((To-Tair)*exp(-time/Tc));
t = 2*Tc;
end Ex2_8;
//======================================================
// Remark
// 1. Area A calculated in the textbook solution is incorrect. It is given as 1.33E-4 whereas it should be 1.13E-4.
// 2. The Original Temperature of the Resistor is, Tresis = 78.4228 deg C. But in the Textbook it is given to be  Tresis = 72.3 deg C.
// 3. 95% of temperature drop does not occur at 3T as given in the textbook. It occurs at 2T approximately.
