//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 3: Heat Exchanger Design
//Example: 3.5 Page 124
//Title: Heat Exchanger Effectiveness
//======================================================
model Ex3_5

//==========
//Parameter Section

parameter Real U(unit = "W/(m^2 K)") = 500 "Overall Heat Transfer Coefficient of the Heat Exchanger";

//==========
//Variable Section

input Real Tce(unit = "deg C",start = 40) "Temperature at which  Cold Flow Enters";
input Real The(unit = "deg C",start = 150) "Temperature at which Hot Flow Enters";
input Real Cc(unit = "W/K",start = 20e3) "Specific Heat of Cold Flow";
input Real Ch(unit = "W/K",start = 10e3) "Specific Heat of Hot Flow";
input Real A(unit = "m^2",start = 30) "Area of the Heat Exchanger";
output Real Q(unit = "kW") "Rate of Heat Transfer";
output Real Tcl(unit = "deg C") "Temperature at which Cold Flow Exits or Leaves";
output Real Thl(unit = "deg C") "Temperature at which Hot Flow Exits or Leaves";
Real NTU "Number of Transfer Units";
Real Cmin(unit = "W/K") "Minimum specific Heat";
Real Cmax(unit = "W/K") "Maximum Specific Heat";
Real K "Cmin/Cmax";
Real e "Heat Exchanger Effectiveness";

//==========
//Equation Section

equation
Cmin = Ch;
Cmax = Cc;
NTU = U*A/Ch;
K = Ch/Cc;          //K = Cmin/Cmax
//From the Graph for Parallel-Flow Heat Exchanger in Page 125 (Figure 3.16) the value of e can be found out by using the values of (Cmin/Cmax) and NTU. The Value of e is found out to be 0.59
e = 0.59;
Q = e*Ch*(The-Tce)/1000;
Thl = The-(Q*1000/Ch);
Tcl = Tce+(Q*1000/Cc);
end Ex3_5;
//======================================================
