//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 4: Analysis of Heat Conduction and Some Steady One-Dimensional Problems
//Example: 4.10 Page 179
//Title: Fin Thermal Resistance
//======================================================
model Ex4_10

//==========
//Parameter Section

parameter Real K(unit = "W/(m K)") = 16 "Thermal Conductivity of the material of the Resistor";
parameter Real heff(unit = "W/(m^2 K)") = 23 "Effective Heat Transfer Coefficient";
  
//==========
//Variable Section

input Real d(unit = "m",start = 0.62e-3) "Outer Diameter of the Long Electrical Leads";
input Real Tair(unit = "deg C",start = 35) "Temperature of Air";
input Real Q(unit = "W",start = 0.1) "Rate of Heat Transfer";
input Real hrad(unit = "W/(m^2 K)",start = 7.17) "Heat Transfer Coefficient due to Radiation";
input Real hconv(unit = "W/(m^2 K)",start = 13) "Heat Transfer Coefficient due to Convection";
input Real A(unit = "m^2",start = 1.1304e-4) "Area of the Resistor";
output Real Rtfin(unit = "K/W") "Thermal Resistance of the wires of the Resistor considering it to be a very Long Fin";
output Real Tresis(unit = "deg C") "Temperature of the Resistor";
Real Rteq(unit = "K/W") "Equivalent Thermal Resistance of the Resistor";
Real pi "Constant";

//==========
//Equation Section

equation
//The values necessary for calculation are taken from Example 2.7 Page 74 as stated in this Problem
//Thermal Resistance of the Fin considering it to be very long
pi = 2*Modelica.Math.asin(1.0);
Rtfin = (K*heff*pi*pi*(d^3)/4)^(-1/2);
//Thermal Resistance due to Fin, Radiation and Convection are in Parallel with each other
Rteq = 1/((2/Rtfin)+(A*hrad)+(A*hconv));
//Temperature of the Resistor
Tresis = Tair+(Q*Rteq);
end Ex4_10;
//======================================================
//Remarks
// 1. The Value of Area, A is taken to be 1.33e-4 in the textbook whereas the value of Area is, A = 1.1304e-4.
// 2. Therefore, the value of Rteq (Equivalent Thermal Resistance) is 311.534 K/W whereas it is 276.8 K/W in the textbook
// 3. Temperature of the Resistor is found out to be, Tresis = 66.1534 deg C whereas it is given as, Tresis = 62.68 deg C in the textbook
