//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 4: Analysis of Heat Conduction and Some Steady One-Dimensional Problems
//Example: 4.11 Page 184
//Title: Heat Loss per metre of Pipe
//======================================================
model Ex4_11

//==========
//Parameter Section

parameter Real hp(unit = "W/(m^2 K)") = 20 "Average Heat Transfer Coefficient on the Pipe";
parameter Real hf(unit = "W/(m^2 K)") = 15 "Average Heat Transfer Coefficient on the Fins";
parameter Real K(unit = "W/(m K)") = 125 "Thermal Conductivity of Brass";

//==========
//Variable Section

input Real dp(unit = "m",start = 3e-2) "Outer Diameter of the Thin Brass Pipe";
input Real t(unit = "m",start = 0.8e-3) "Thickness of the Straight Circular Fins on the Pipe";
input Real df(unit = "m",start = 8e-2) "Diameter of the Fins";
input Real d(unit = "m",start = 2e-2) "Spacing between the Fins";
input Real Twater(unit = "deg C",start = 85) "Temperature of Hot Water that flows in the Brass Pipe";
input Real Ta(unit = "deg C",start = 22) "Ambient Temperature";
output Real Qbf(unit = "W/m") "Heat Loss before the Fins are Added";
output Real Qaf(unit = "W/m") "Heat Loss after the Fins are Added";
Real Xua "Fraction of Unfinned Area";
Real n "Number of Fins per metre";
Real r "Ratio of Radii of the Fin to the Radii of the Pipe";
Real A(unit = "m^2") "Area";
Real C "sqrt((hf*L^3)/(K*A))";
Real nf(unit = "%") "Percentage Efficiency of the Fin";
Real pi "Constant";

//==========
//Equation Section

equation
pi = 2*Modelica.Math.asin(1.0);
r = df/dp;
A = 0.025*t;
C = ((hf*(((df/2)-(dp/2))^3))/(K*A))^0.5;
//Using the values of r (i.e,.) r2/r1 and C (i.e,.) sqrt((hf*L^3)/(K*A)), the Efficiency of the Fin can be found out from the Graph (Figure 4.14a) in Page 185. The Fin Efficiency is found out to be nf = 89%.
nf = 89;
Qbf = pi*dp*hp*(Twater-Ta);
Xua = (d-t)/d;
n = 1/d;      //Number of Fins per metre 
Qaf = Qbf*Xua+((nf/100)*(2*pi*(((df/2)^2)-((dp/2)^2)))*n*hf*(Twater-Ta));
//Qaf = 4.02*Qbf
end Ex4_11;
//======================================================
