//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 5: Transient and Multidimensional Heat Conduction
//Example: 5.2 Page 216
//Title: Net Heat Removal
//======================================================
model Ex5_2

//==========
//Parameter Section

parameter Real rho(unit = "kg/m^3") = 997.6 "Density of Water";
parameter Real Cp(unit = "J/(kg K)") = 4180 "Specific Heat Capacity of Water";
parameter Real K(unit = "W/(m K)") = 0.603 "Thermal Conductivity of Water";

//==========
//Variable Section

input Real Na(start = 12) "Number of Apples";
input Real d(unit = "m",start = 0.1) "Diameter of the Spherical Apple";
input Real Ta(unit = "deg C",start = 30) "Temperature of the Apples";
input Real Tr(unit = "deg C",start = 5) "Temperature of the Refrigerator";
input Real havg(unit = "W/(m^2 K)",start = 6) "Average Heat Transfer Coefficient";
input Real t(unit = "s",start = 3600) "Time for which the Apples are kept in the Refrigerator";
input Real Tfa(unit = "deg C",start = 10) "Final Temperature of the Apples";
output Real Q(unit = "kJ") "Net Amount of Heat Removed";
output Real tf(unit = "s") "Time Taken to bring the Apples to its Final Temperature";
output Real Tc(unit = "deg C") "Temperature of the centre of the Apples after 1 hr";
Real Fo "Fourier Number";
Real Bi "Biot Number";
Real phi "Constant of Temperature";
Real phi1 "Constant of Temperature";
Real phi2 "Constant of Temperature";
Real Fo1 "Fourier Number";
Real pi "Constant";

//==========
//Equation Section

equation
pi = 2*Modelica.Math.asin(1.0);     //Constant
Fo = (K*t)/(rho*Cp*((d/2)^2));
Bi = havg*(d/2)/K;
//From the Upper-Left Hand Corner of the Figure 5.9 Page 213 using the Values of Fo = 0.208 and 1/Bi = 2.01, the Value of phi = 0.85
phi = 0.85;
Tc = (phi*(Ta-Tr))+Tr;
phi1 = (Tfa-Tr)/(Ta-Tr);
//From the Figure 5.9 Page 213 using the Values of phi1 = 0.2 and 1/Bi = 2.01, the Value of Fo = 1.29
Fo1 = 1.29;
Fo1 = (K*tf)/(rho*Cp*((d/2)^2));
//From the Figure 5.10(c) Page 215 using the Values Bi = 1/2.01 and Fo = 1.29, the Value of phi2 = 0.80
phi2 = 0.80;
Q*1000 = Na*rho*Cp*4*pi*((d/2)^3)*(Ta-Tr)*phi2/3;
end Ex5_2;
//======================================================
