//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 5: Transient and Multidimensional Heat Conduction
//Example: 5.3 Page 217
//Title: Transient Conduction in One Dimensional Slab
//======================================================
model Ex5_3

//==========
//Parameter Section

parameter Real h(unit = "W/(m^2 K)") = 30000 "Average Heat Transfer Coefficient";
parameter Real K(unit = "W/(m K)") = 13.8 "Thermal Conductivity of Nichrome";
parameter Real alpha(unit = "m^2/s") = 0.00000343 "Thermal Diffusivity of Nichrome Wire";

//==========
//Variable Section

input Real d(unit = "m",start = 1e-3) "Diameter of the Nichrome Wire";
output Real Tdev(unit = "%") "Percentage Deviation in Temperature";
Real Bi "Biot Number";
Real psi "(w*(r^2))/alpha";
Real pi "Constant";

//==========
//Equation Section

equation
Bi = h*(d/2)/K;     //Biot Number Calculation
pi = 2*Modelica.Math.asin(1.0);
psi = ((2*pi*60)*(d/2)^2)/alpha;      //w = 2*pi*60
//Using the Values of Bi and psi, the Deviation in Temperature can be found out from the Graph (Figure 5.12) in Page 221. The Deviation in Temperature is found out to be 0.04 and therefore the Percentage Deviation in Temperature is 4%.
Tdev = 4;
//4% of Temperature Deviation does not alter the Outcome or the Results of the Experiment. Hence, both the Experiments are considered to be Valid.
end Ex5_3;
//======================================================
