//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 7: Forced Convection in a Variety of Configurations
//Example: 7.2 Page 356
//Title: Heat Transfer in Fully Developed Air Flow
//======================================================
model Ex7_2

//==========
//Parameter Section

parameter Real Cp(unit = "J/(kg K)") = 1004 "Specific Heat Capacity of Air at Mean Film Temperature";
parameter Real nu(unit = "m^2/s") = 16.4e-6 "Kinematic Viscosity of Air at Mean Film Temperature";
parameter Real Pr = 0.711 "Prandtl Number of Air at Mean Film Temperature";
parameter Real rho(unit = "kg/m^3") = 1.159 "Density of Air at Mean Film Temperature";
parameter Real K(unit = "W/(m K)") = 0.0266 "Thermal Conductivity of Air at Mean Film Temperature";

//==========
//Variable Section

input Real Tai(unit = "deg C",start = 27) "Inlet Temperature of Air";
input Real Tao(unit = "deg C",start = 40) "Outlet Temperature of Air";
input Real u(unit = "m/s",start = 2) "Velocity of Air in the Pipe";
input Real d(unit = "m",start = 1e-2) "Diameter of the Pipe";
input Real l(unit = "m",start = 20e-2) "Length of the Pipe to which an Electric Heater is attached";
output Real q(unit = "W/m^2") "Constant Heat Flux supplied to the Pipe";
output Real Twe(unit = "deg C") "Wall Temperature at Exit";
Real Tf(unit = "deg C") "Mean Film Temperature";

//==========
//Equation Section

equation
Tf = (Tai+Tao)/2;     //Mean Film Temperature
q = rho*Cp*u*(Tao-Tai)*((d/2)/(2*l));    //Refer Page 356
Twe = Tao+((q*d)/(5.05*K));             //Refer Page 356
end Ex7_2;
//======================================================
