//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 7: Forced Convection in a Variety of Configurations
//Example: 7.7 Page 380
//Title: Velocity of Air Flow
//======================================================
model Ex7_7

//==========
//Parameter Section

parameter Real K(unit = "W/(m K)") = 0.0264 "Thermal Conductivity of Air at 30 deg C";
parameter Real nu(unit = "m^2/s") = 1.596e-5 "Kinematic Viscosity of Air at 30 deg C";
parameter Real Pr = 0.71 "Prandtl Number of Air at 30 deg C";

//==========
//Variable Section

input Real d(unit = "m",start = 0.0001) "Diameter of the Electric Resistance Wire";
input Real Tw(unit = "deg C",start = 40) "Temperature of the Electric Resistance Wire";
input Real Ta(unit = "deg C",start = 20) "Temperature of Air";
input Real q(unit = "W/m",start = 17.8) "Heat Dissipated by the Electric Resistance Wire";
output Real u(unit = "m/s") "Velocity of Air Flow";
Real havg(unit = "W/(m^2 K)") "Average Heat Transfer Coefficient";
Real Nu "Nusselt's Number";
Real Re "Reynolds Number";
Real pi "Constant";

//==========
//Equation Section

equation
pi=2*Modelica.Math.asin(1.0);         //Constant pi
havg = q/(pi*d*(Tw-Ta));
Nu = havg*d/K;
Re = ((Nu-0.3)*((1+((0.4/Pr)^(2/3)))^0.25)/(0.62*((Pr)^(1/3))))^2;
u = nu*Re/d;
end Ex7_7;
//======================================================
