//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 8: Natural Convection in Single Phase Fluids and during Film Condensation
//Example: 8.3 Page 416
//Title: Heat Transfer Coefficient Verification
//======================================================
model Ex8_3

//==========
//Parameter Section

parameter Real Pr = 0.71 "Prandtl Number of Air at 35 deg C";
parameter Real nu(unit = "m^2/s") = 16.45e-6 "Kinematic Viscosity of Air at 35 deg C";
parameter Real alpha(unit = "m^2/s") = 2.318e-5 "Thermal Diffusivity of Air at 35 deg C";
parameter Real K(unit = "W/(m K)") = 0.0267 "Thermal Condutivity of Air at 35 deg C";
parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to Gravity at the Earth's Surface";

//==========
//Variable Section

input Real Tair(unit = "deg C",start = 20) "Temperature of Air";
input Real Twall(unit = "deg C",start = 50) "Temperature of the Wall";
input Real l(unit = "m",start = 0.3) "Length of the Wall";
output Real hp(unit = "W/(m^2 K)") "Heat Transfer Coefficient Value obtained by Prediction";
output Real hc(unit = "W/(m^2 K)") "Heat Transfer Coefficient Value obtained by Correlation";
Real Nup "Nusselt Number by Prediction";
Real Nuc "Nusselt Number by Correlation";
Real Ra "Rayleigh's Number";
Real beta(unit = "1/K") "Coefficient of Thermal Expansion";

//==========
//Equation Section

equation
beta = 1/(273+Tair);
Ra = (g*beta*(Twall-Tair)*(l^3))/(alpha*nu);
Nup = 0.678*(Ra^0.25)*((Pr/(0.952+Pr))^0.25);
hp = Nup*K/l;
Nuc = 0.68+(0.67*(Ra^0.25)/((1+((0.492/Pr)^(9/16)))^(4/9)));
hc = Nuc*K/l;
end Ex8_3;
//======================================================
