//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 8: Natural Convection in Single Phase Fluids and during Film Condensation
//Example: 8.4 Page 420
//Title: g Level
//======================================================
model Ex8_4

//==========
//Parameter Section

parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to Gravity on Earth's Surface";
parameter Real  nu(unit = "m^2/s") = 2.062e-5 "Kinematic Viscosity of Air";
parameter Real alpha(unit = "m^2/s") = 2.92e-5 "Thermal Diffusivity of Air";
parameter Real K(unit = "W/(m K)") = 0.0297 "Thermal Conductivity of Air";
parameter Real Pr = 0.706 "Prandtl Number of Air";

//==========
//Variable Section

input Real d(unit = "m",start = 0.5e-2) "Diameter of the Tube";
input Real To(unit = "K",start = 400) "Temperature of Hot Oil in the Tube";
input Real Tair(unit = "K",start = 300) "Temperature of Air";
Real havg1(unit = "W/(m^2 K)") "Average Heat Transfer Coefficient";
Real havg2(unit = "W/(m^2 K)") "Average Heat Transfer Coefficient";
Real havg3(unit = "W/(m^2 K)") "Average Heat Transfer Coefficient";
Real havg4(unit = "W/(m^2 K)") "Average Heat Transfer Coefficient";
Real beta(unit = "1/K") "Coefficient of Thermal Expansion";
Real Ra "Rayleigh's Number";
Real Nu "Nusselt's Number";
input Real gl1(start = 1e-6) "g-Level";
Real Q1(unit = "W/m") "Rate of Heat Transfer per unit Length of the Tube";
input Real gl2(start = 1e-5) "g-Level";
Real Q2(unit = "W/m") "Rate of Heat Transfer per unit Length of the Tube";
input Real gl3(start = 1e-4) "g-Level";
Real Q3(unit = "W/m") "Rate of Heat Transfer per unit Length of the Tube";
input Real gl4(start = 1e-2) "g-Level";
Real Q4(unit = "W/m") "Rate of Heat Transfer per unit Length of the Tube";
Real pi "Constant";

//==========
//Equation Section

equation
pi = 2*Modelica.Math.asin(1.0);     //Constant
beta = 1/Tair;
Ra = g*beta*(To-Tair)*(d^3)/(nu*alpha);
Nu = ((0.6+(0.387*(((Ra*gl1)/((1+((0.559/Pr)^(9/16)))^(16/9)))^(1/6))))^2);
havg1 = Nu*K/d;
havg2 = ((0.6+(0.387*(((Ra*gl2)/((1+((0.559/Pr)^(9/16)))^(16/9)))^(1/6))))^2)*K/d;
havg3 = ((0.6+(0.387*(((Ra*gl3)/((1+((0.559/Pr)^(9/16)))^(16/9)))^(1/6))))^2)*K/d;
havg4 = ((0.6+(0.387*(((Ra*gl4)/((1+((0.559/Pr)^(9/16)))^(16/9)))^(1/6))))^2)*K/d;
Q1 = pi*d*havg1*(To-Tair);
Q2 = pi*d*havg2*(To-Tair);
Q3 = pi*d*havg3*(To-Tair);
Q4 = pi*d*havg4*(To-Tair);
end Ex8_4;
//======================================================
