//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 8: Natural Convection in Single Phase Fluids and during Film Condensation
//Example: 8.5 Page 429
//Title: Average Surface Temperature of Heater
//======================================================
model Ex8_5

//==========
//Parameter Section

parameter Real K(unit = "W/(m K)") = 0.02614 "Thermal Conductivity of Air";
parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to Gravity at the Earth's Surface";
parameter Real nu(unit = "m^2/s") = 1.566e-5 "Kinematic Viscosity of Air";
parameter Real alpha(unit = "m^2/s") = 2.203e-5 "Thermal Diffusivity of Air";
parameter Real Pr = 0.711 "Prandtl Number of Air";

//==========
//Variable Section

input Real d(unit = "m",start = 0.17) "Diameter of the Horizontal Circular Disk Heater";
input Real Ta(unit = "deg C",start = 27) "Temperature of Air";
input Real Q(unit = "W",start = 15) "Power Delivered by the Heater";
output Real delT(unit = "deg C") "Average Change in Temperature";
output Real delTc(unit = "deg C") "Corrected Average Temperature Change";
output Real Tsavg(unit = "deg C") "Average Surface Temperature";
output Real Tsavgc(unit = "deg C") "Corrected Average Surface Temperature";
Real beta(unit = "1/K") "Coefficient of Volume Expansion";
Real q(unit = "W/m^2") "Power Delivered per unit Area of the Heater";
Real pi "Constant";

//==========
//Equation Section

equation
pi=2*Modelica.Math.asin(1.0);         //Constant pi
beta = (Ta+273)^(-1);
q = Q/(pi*((d/2)^2));
delT = (1.18*q*d/K)/((((g*beta*q*(d^4))/(K*nu*alpha))^(1/6))*(Pr^0.028));
Tsavg = delT+Ta;
delTc = (1.18*q*d/0.03104)/((((g*beta*q*(d^4))/(0.03104*3.231*(2.277e-10)))^(1/6))*0.99);
//Property Values are taken at T = Ta+Tsavg/2.
Tsavgc = delTc+Ta;
end Ex8_5;
//======================================================
//Remark
//The Average Temperature Change, delT = 144.229 K whereas it is given as delT = 140 K in the Textbook
