//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 9: Heat Transfer in Boiling and Other Phase Change Configurations
//Example: 9.3 Page 481
//Title: Steam Velocity to Destabilize Liquid Flow
//======================================================
model Ex9_3

//==========
//Parameter Section

parameter Real sigma(unit = "N/m") = 0.0589 "Surface Tension of Water at 100 deg C";
parameter Real rhog(unit = "kg/m^3") = 0.577 "Density of Gas";

//==========
//Variable Section

input Real lambdah(unit = "m",start = 0.04) "wavelength of the Corrrugations in the Pipe in the Axial Direction";
output Real ug(unit = "m/s") "Steam Velocity required to Destabilize the Liquid Flow";
Real pi "Constant";

//==========
//Equation Section

equation
pi = 2*Modelica.Math.asin(1.0);
ug = ((2*pi*sigma)/(rhog*lambdah))^0.5;     //Refer Page 480
end Ex9_3;
//======================================================
