//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 9: Heat Transfer in Boiling and Other Phase Change Configurations
//Example: 9.4 Page 481
//Title: Maximum Spacing
//======================================================
model Ex9_4

//==========
//Parameter Section

parameter Real g(unit = "m/s^2") = 9.81 "Acceleration Due to Gravity";
parameter Real rho(unit = "kg/m^3") = 13600 "Density of Mercury";
parameter Real sigma(unit = "N/m") = 0.487 "Surface Tension of Mercury";

//==========
//Variable Section

output Real lambdad(unit = "m") "Spacing or Wavelength";
Real pi "Constant";

//==========
//Equation Section

equation
pi = 2*Modelica.Math.asin(1.0);     //Constant
lambdad = (2*pi*(3^0.5))*((sigma/(g*rho))^0.5);
end Ex9_4;
//======================================================
