//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 9: Heat Transfer in Boiling and Other Phase Change Configurations
//Example: 9.6 Page 485
//Title: Heat Flux in Mercury 
//======================================================
model Ex9_6

//==========
//Parameter Section

parameter Real hfg(unit = "J/kg") = 292.5e3 "Latent Heat of Vapourization of Mercury at 355 deg C";
parameter Real rhof(unit = "kg/m^3") = 13600 "Density of Mercury";
parameter Real rhog(unit = "kg/m^3") = 4.0 "Density of Gas";
parameter Real sigma(unit = "N/m") = 0.418 "Surface Tension of Mercury";
parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to Gravity";

//==========
//Variable Section

output Real qmax(unit = "W/m^2") "Maximum Heat Flux in Mercury on Large Flat Plate";

//==========
//Equation Section

equation
qmax = 0.149*(rhog^0.5)*hfg*((g*(rhof-rhog)*sigma)^0.25);
end Ex9_6;
//======================================================
//Remark
//Density of Mercury, rhof = 13600 kg/m^3. But in the book the Density of Mercury is taken to be, rhof = 13400 kg/m^3.
